<?php declare(strict_types=1);

namespace Newland\Toubiz\Map\Neos\Provider\DefaultProviders;

use Neos\ContentRepository\Domain\Model\Node;
use Newland\NeosCommon\Service\NodeService;
use Newland\Toubiz\Map\Neos\Provider\MapDataProvider;
use Newland\Toubiz\Sync\Neos\Domain\Model\Event;
use Neos\Flow\Annotations as Flow;
use Newland\Toubiz\Sync\Neos\Domain\Repository\EventRepository;

/**
 * @MapDataProvider()
 */
class SelectedEvents extends SubnodeBasedMarkerProvider
{
    use EventFormatting;

    protected $nodeType = 'Newland.Toubiz.Map.Neos:Map.Markers.SelectedEvents';

    /**
     * @var EventRepository
     * @Flow\Inject()
     */
    protected $eventRepository;

    /**
     * @var NodeService
     * @Flow\Inject()
     */
    protected $nodeService;

    public function markersForNode(Node $node, int $offset, int $limit): array
    {
        $eventIds = $node->getProperty('events') ?: [];

        $markers = [];
        if (!empty($eventIds)) {
            $markers = $this->buildMarkersFromEventIds(
                array_slice($eventIds, $offset, $limit),
                $node
            );
        }

        return $markers;
    }

    protected function buildMarkersFromEventIds(array $eventIds, Node $node): array
    {
        $language = $this->nodeService->getLanguage($node);
        $events = $this->eventRepository->withLanguage(
            $language,
            function () use ($eventIds) {
                return $this->eventRepository->findByIdentifiers($eventIds);
            }
        );

        $markers = [];
        foreach ($events as $event) {
            /** @var Event $event */
            $marker = $this->eventToMarker($event, $node);
            if (!$marker) {
                continue;
            }

            $markers[] = $marker;
        }
        return $markers;
    }

    public function numberOfMarkersForNode(Node $node): int
    {
        return count($node->getProperty('events') ?: []);
    }
}
