<?php
namespace Newland\Toubiz\Map\Neos\Controller;

/*
 * This file is part of the "toubiz-map-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\Flow\Annotations as Flow;
use Neos\Flow\Mvc\View\ViewInterface;
use Newland\NeosCommon\Service\ConfigurationService;
use Newland\NeosCommon\Service\NodeService;
use Newland\Toubiz\Map\Neos\Service\ApiKeyService;

/**
 * Map controller.
 *
 * @Flow\Scope("singleton")
 */
class MapController extends AbstractActionController
{

    /**
     * @var array
     * @Flow\InjectConfiguration(package="Newland.Toubiz.Sync.Neos.services.Outdooractive/Api")
     */
    protected $outdooractiveConfiguration;

    /**
     * @var ApiKeyService
     * @Flow\Inject()
     */
    protected $apiKeyService;

    /**
     * @var NodeService
     * @Flow\Inject()
     */
    protected $nodeService;

    /**
     * @var ConfigurationService
     * @Flow\Inject()
     */
    protected $configurationService;

    protected function initializeView(ViewInterface $view)
    {
        $view->assignMultiple($this->properties);
    }

    /**
     * Show action.
     *
     * Displays the map.
     *
     * @return void
     */
    public function showAction(): void
    {
        $outdooractiveCredentials = null;
        if ($this->outdooractiveConfiguration !== null) {
            $outdoorActiveConfigurations = $this->configurationService->getCurrentSiteConfiguration(
                $this->node,
                'Newland.Toubiz.Poi.Neos.outdoorActiveConfigurations'
            );
            $outdooractiveCredentials = $outdoorActiveConfigurations ??
                reset($this->outdooractiveConfiguration['clients']);
        }

        $this->view->assignMultiple(
            [
                'configuration' => $this->configuration,
                'apiKeys' => $this->apiKeyService->getApiKeys($this->node),
                'properties' => $this->properties,
                'outdooractiveCredentials' => $outdooractiveCredentials,
                'node' => $this->node,
            ]
        );

        if ($this->isInBackend()) {
            $this->view->assign('childrenPreview', $this->request->getInternalArgument('__children'));
        }
    }
}
