<?php declare(strict_types=1);

namespace Newland\Toubiz\Map\Neos\Controller;

use Neos\Error\Messages\Message;
use Neos\Flow\Mvc\Controller\ActionController;
use Neos\Flow\Mvc\FlashMessageContainer;
use Neos\Flow\Security\SessionDataContainer;
use Newland\Toubiz\Map\Neos\Provider\MapDataProvider;
use Neos\Flow\Annotations as Flow;
use Newland\Toubiz\Map\Neos\Provider\MapDataProviderService;

class BackendController extends ActionController
{

    /**
     * @var MapDataProviderService
     * @Flow\Inject()
     */
    protected $mapDataProvider;

    /**
     * @var FlashMessageContainer
     * @Flow\Inject()
     */
    protected $messages;

    public function indexAction(): void
    {
        $this->view->assign('messages', $this->messages->getMessagesAndFlush());
    }

    public function clearCacheAction(): void
    {
        $this->mapDataProvider->clearCache();
        $this->messages->addMessage(new Message('Cleared cache'));
        $this->redirect('index');
    }
}
