<?php
namespace Newland\Toubiz\Map\Neos\DataSource;

use Neos\ContentRepository\Domain\Model\NodeInterface;
use Neos\Flow\Annotations as Flow;
use Neos\Flow\Cache\CacheManager;
use Neos\Neos\Service\DataSource\AbstractDataSource;
use Newland\Toubiz\Sync\Neos\Domain\Repository\EventRepository;

/**
 * @Flow\Scope("singleton")
 */
class EventDataSource extends AbstractDataSource
{
    protected static $identifier = 'newland-toubiz-map-neos-events';
    const CACHE_NAME = 'Newland_Toubiz_map_neos-EventDataSource';
    const CACHE_LIFETIME_SECONDS = 60 * 60 * 24;

    /**
     * @var EventRepository
     * @Flow\Inject()
     */
    protected $eventRepository;

    /**
     * @Flow\Inject()
     * @var CacheManager
     */
    protected $cacheManager;

    /**
     * The return value must be JSON serializable data structure.
     *
     * @param NodeInterface $node The node that is currently edited (optional)
     * @param array $arguments Additional arguments (key / value)
     * @return mixed JSON serializable data
     * @throws \Neos\Cache\Exception\NoSuchCacheException
     * @api
     */
    public function getData(NodeInterface $node = null, array $arguments)
    {
        $cache = $this->cacheManager->getCache(self::CACHE_NAME);

        // Note: Using one cache key for all nodes since the result does not change from node to node.
        $cacheKey = 'events';
        if ($cache->has($cacheKey)) {
            return $cache->get($cacheKey);
        }

        $query = $this->eventRepository
            ->createQueryBuilder('event');

        $events = $query
            ->select('event.Persistence_Object_Identifier as value, event.title as label')
            ->leftJoin('event.location', 'address')
            ->where($query->expr()->isNotNull('address.latitude'))
            ->getQuery()
            ->execute();

        $cache->set($cacheKey, $events, [], self::CACHE_LIFETIME_SECONDS);
        return $events;
    }
}
