<?php declare(strict_types=1);

namespace Newland\Toubiz\Map\Neos\Provider\Contract;

use Newland\Toubiz\Api\ObjectAdapter\Attributes\TourAttributes;

class Marker implements \JsonSerializable
{
    /** @var string */
    public $id = '';

    /** @var string[] */
    public $paths = [];

    /** @var string */
    public $title = '';

    /** @var string|null */
    public $description = '';

    /** @var float */
    public $longitude = 0.0;

    /** @var float */
    public $latitude = 0.0;

    /** @var string|null */
    public $categoryTitle = null;

    /** @var string|null */
    public $url = null;

    /** @var string|null */
    public $imageUrl = null;

    /** @var string|null */
    public $imageAlt = null;

    /** @var array */
    public $defaultStyle = [];

    /** @var array|null */
    public $tour = [];

    /** @var string|null */
    public $outdoorActiveTrackingId = null;

    /** @var array<string, mixed> */
    public $additionalProperties = [];

    public function __construct(string $id, array $paths, float $longitude, float $latitude, string $title)
    {
        $this->id = $id;
        $this->paths = $paths;
        $this->longitude = $longitude;
        $this->latitude = $latitude;
        $this->title = $title;
    }

    public function toArray(): array
    {
        $image = null;
        if ($this->imageUrl !== null) {
            $image = [
                'url' => $this->imageUrl,
                'alt' => $this->imageAlt
            ];
        }
        $array = [
            'id' => $this->id,
            'paths' => $this->paths,
            'title' => $this->title,
            'categoryTitle' => $this->categoryTitle ?: null,
            'url' => $this->url ?: null,
            'image' => $image,
            'coordinates' => [
                'longitude' => $this->longitude,
                'latitude' => $this->latitude,
            ],
            'defaultStyle' => $this->defaultStyle,
            'tour' => $this->tour,
            'outdoorActiveTrackingId' => $this->outdoorActiveTrackingId,
        ];

        return array_replace($array, $this->additionalProperties);
    }

    public function jsonSerialize(): array
    {
        return $this->toArray();
    }

    public function merge(Marker $marker): Marker
    {
        $new = clone $this;
        $new->paths = array_merge($new->paths, $marker->paths);
        return $new;
    }
}
