<?php declare(strict_types=1);

namespace Newland\Toubiz\Map\Neos\Provider\Contract;

use Neos\ContentRepository\Domain\Model\Node;
use Neos\ContentRepository\Domain\Model\NodeInterface;
use Neos\Flow\Http\Request;

class ProviderContext
{
    /** @var Node */
    protected $mapNode;

    /** @var Request|null */
    protected $request;

    public function __construct(Node $mapNode, ?Request $request)
    {
        if (!$mapNode->getNodeType()->isOfType('Newland.Toubiz.Map.Neos:Map')) {
            throw new \InvalidArgumentException(sprintf(
                'Node must be of type `Newland.Toubiz.Map.Neos:Map` but is of type %s',
                $mapNode->getNodeType()->getName()
            ));
        }

        $this->mapNode = $mapNode;
        $this->request = $request;
    }

    public function mapNode(): Node
    {
        return $this->mapNode;
    }

    public function request(): ?Request
    {
        return $this->request;
    }
}
