<?php declare(strict_types=1);

namespace Newland\Toubiz\Map\Neos\Tests\Unit\Serialization\Markers;

use Neos\ContentRepository\Domain\Model\Node;
use Neos\Neos\Domain\Model\Site;
use Newland\Toubiz\Map\Neos\Provider\Contract\ProviderContext;
use Newland\Toubiz\Map\Neos\Provider\DefaultProviders\SelectedArticles;
use Newland\Toubiz\Sync\Neos\Tests\Factory\ArticleFactory;
use Ramsey\Uuid\Uuid;

class SelectedArticlesTest extends MarkerSerializerTestCase
{

    /** @var SelectedArticles */
    protected $subject;

    /** @var ArticleFactory */
    protected $articleFactory;

    public function setUp(): void
    {
        parent::setUp();
        $this->subject = $this->objectManager->get(SelectedArticles::class);
        $this->articleFactory = new ArticleFactory($this->objectManager);
    }

    public function testFetchesSpecificArticlesFromDatabase(): void
    {
        [ $first, $second, $third ] = $this->articleFactory->createMultiple(3);
        $node = $this->initializeSelectedArticlesNode([
            'articles' => [
                $first->getPersistenceObjectIdentifier(),
                $second->getPersistenceObjectIdentifier(),
            ],
        ]);

        $result = $this->subject->getMarkers(new ProviderContext($this->mapNode, null));
        $this->assertCount(2, $result);
    }

    public function testIgnoresArticlesThatDoNotExist(): void
    {
        [ $first, $second, $third ] = $this->articleFactory->createMultiple(3);
        $node = $this->initializeSelectedArticlesNode([
            'articles' => [
                Uuid::uuid4(),
                $first->getPersistenceObjectIdentifier(),
                Uuid::uuid4(),
                $second->getPersistenceObjectIdentifier(),
                Uuid::uuid4(),
            ],
        ]);

        $result = $this->subject->getMarkers(new ProviderContext($this->mapNode, null));
        $this->assertCount(2, $result);
    }

    public function testDoesNotRenderSameItemTwice(): void
    {
        $article = $this->articleFactory->create([ ]);
        $node = $this->initializeSelectedArticlesNode([
            'articles' => [
                $article->getPersistenceObjectIdentifier(),
                $article->getPersistenceObjectIdentifier(),
                $article->getPersistenceObjectIdentifier(),
            ],
        ]);
        $result = $this->subject->getMarkers(new ProviderContext($this->mapNode, null));
        $this->assertCount(1, $result);
    }

    private function initializeSelectedArticlesNode(array $properties = []): Node
    {
        return $this->initializeNode(
            '/sites/foo/main/map/children/filter-item/children/foo',
            'live',
            $this->site,
            $properties,
            'de',
            'Newland.Toubiz.Map.Neos:Map.Markers.SelectedArticles'
        );
    }

}
