<?php
namespace Newland\Toubiz\Map\Neos\DataSource;

use Neos\ContentRepository\Domain\Model\NodeInterface;
use Neos\Eel\FlowQuery\FlowQuery;
use Neos\Neos\Service\DataSource\AbstractDataSource;
use Neos\Flow\Annotations as Flow;

/**
 * @Flow\Scope("singleton")
 */
class PageForMapDataSource extends AbstractDataSource
{
    static protected $identifier = 'newland-toubiz-map-neos-pages';
    const LABEL_SEPARATOR = ' ▶ ';

    public function pagesForMap(NodeInterface $forNode, array $filterForIdentifiers = []): array
    {
        $query = (new FlowQuery([ $forNode->getContext()->getCurrentSiteNode() ]))
            ->find('[instanceof Neos.Neos:Document][displayOnToubizMap]');

        if (!empty($filterForIdentifiers)) {
            $pages = [];
            foreach ($query as $page) {
                /** @var NodeInterface $page */
                if (in_array($page->getIdentifier(), $filterForIdentifiers)) {
                    $pages[] = $page;
                }
            }
            return $pages;
        }

        return (array) $query->getIterator();
    }

    /**
     * Get data
     *
     * The return value must be JSON serializable data structure.
     *
     * @param NodeInterface $node The node that is currently edited (optional)
     * @param array $arguments Additional arguments (key / value)
     * @return mixed JSON serializable data
     * @api
     */
    public function getData(NodeInterface $node = null, array $arguments)
    {
        if ($node === null) {
            return [];
        }

        $pages = [];
        foreach ($this->pagesForMap($node) as $page) {
            /** @var NodeInterface $page */
            $pages[] = [ 'value' => $page->getIdentifier(), 'label' => $this->formatLabel($page) ];
        }

        return $pages;
    }

    private function formatLabel(NodeInterface $node): string
    {
        $site = $node->getContext()->getCurrentSiteNode();

        $name = $node->getProperty('title') ?: $node->getName();
        while ($node = $node->getParent()) {
            $name = ($node->getProperty('title') ?: $node->getName()) . self::LABEL_SEPARATOR . $name;
            if ($node === $site) {
                break;
            }
        }

        return $name;
    }
}
