<?php
namespace Newland\Toubiz\Map\Neos\DataSource;

use Neos\Flow\Annotations as Flow;
use Neos\ContentRepository\Domain\Model\NodeInterface;
use Neos\Neos\Service\DataSource\AbstractDataSource;
use Newland\Toubiz\Sync\Neos\Domain\Repository\ArticleRepository;

/**
 * @Flow\Scope("singleton")
 */
class CitiesDataSource extends AbstractDataSource
{
    static protected $identifier = 'newland-toubiz-map-neos-cities';

    /**
     * @var ArticleRepository
     * @Flow\Inject
     */
    protected $articleRepository;

    public function getData(NodeInterface $node = null, array $arguments = []): array
    {
        return $this->articleRepository
            ->createQueryBuilder('article')
            ->select(
                'article.zip as value',
                'CONCAT(article.zip, \': \', GROUP_CONCAT(DISTINCT article.city)) as label'
            )
            ->where('article.zip != :emptyString AND article.city != :emptyString')
            ->orderBy('article.zip')
            ->groupBy('article.zip')
            ->getQuery()
            ->execute([ 'emptyString' => '' ]);
    }
}
