<?php declare(strict_types=1);

namespace Newland\Toubiz\Map\Neos\Provider\Contract;

class FilterItem implements \JsonSerializable
{
    /** @var string */
    public $id = '';

    /** @var string */
    public $path = '';

    /** @var string */
    public $title = '';

    /** @var array */
    public $style = [];

    /** @var bool */
    public $overwriteMarkerStyles = true;

    /** @var bool */
    public $openByDefault = false;

    /** @var FilterItem[] */
    public $children = [];

    /** @var array */
    public $additionalProperties = [];

    public function __construct(string $id, string $path, string $title)
    {
        $this->id = $id;
        $this->path = $path;
        $this->title = $title;
    }

    public function toArray(): array
    {
        $array = [
            'id' => $this->id,
            'path' => $this->path,
            'title' => $this->title,
            'style' => $this->style,
            'overwriteMarkerStyles' => $this->overwriteMarkerStyles,
            'openByDefault' => $this->openByDefault,
            'children' => array_map(function (FilterItem $filterItem) {
                return $filterItem->toArray();
            }, $this->children),
        ];

        return array_replace_recursive($array, $this->additionalProperties);
    }

    public function jsonSerialize(): array
    {
        return $this->toArray();
    }
}
