<?php declare(strict_types=1);

namespace Newland\Toubiz\Map\Neos\Provider\DefaultProviders;

use Neos\ContentRepository\Domain\Model\Node;
use Neos\ContentRepository\Domain\Model\NodeInterface;
use Neos\ContentRepository\Domain\NodeType\NodeTypeConstraints;
use Neos\ContentRepository\Domain\NodeType\NodeTypeName;
use Neos\Eel\FlowQuery\FlowQuery;
use Neos\Flow\ObjectManagement\Exception\InvalidObjectException;
use Newland\Toubiz\Map\Neos\Provider\Contract\Marker;
use Newland\Toubiz\Map\Neos\Provider\Contract\MarkerProvider;
use Newland\Toubiz\Map\Neos\Provider\Contract\ProviderContext;
use Newland\Toubiz\Map\Neos\Provider\MapDataProviderService;

abstract class SubnodeBasedMarkerProvider implements MarkerProvider
{
    public const FILTER_ITEM = 'Newland.Toubiz.Map.Neos:Map.FilterItem';
    public const CONTENT_COLLECTION = 'Neos.Neos:ContentCollection';

    /** @var string */
    protected $nodeType;

    /** @return Marker[] */
    abstract public function markersForNode(Node $node): array;

    public function applies(Node $node): bool
    {
        return $node->getNodeType()->isOfType($this->nodeType);
    }

    public function getMarkers(ProviderContext $context): array
    {
        if (empty($this->nodeType)) {
            throw new InvalidObjectException(sprintf(
                'The $nodeType property is not configured in subnode based marker provider `%s`',
                static::class
            ));
        }

        $markers = [ [] ];
        foreach ($this->findMarkerNodes($context->mapNode()) as $node) {
            $markers[] = $this->markersForNode($node);
        }

        return array_merge(...$markers);
    }

    public function markerCacheKey(ProviderContext $context): ?string
    {
        return md5(static::class . $context->mapNode()->getContextPath());
    }


    private function findMarkerNodes(Node $node): \Generator
    {
        $query = (new FlowQuery([ $node ]))
            ->find(sprintf('[instanceof %s]', MapDataProviderService::TYPE_MARKERS_WILDCARD));

        foreach ($query as $item) {
            if (!$item->isHidden()) {
                yield $item;
            }
        }
    }
}
