<?php declare(strict_types=1);

namespace Newland\Toubiz\Map\Neos\Eel\Helper;

use Neos\ContentRepository\Domain\Model\Node;
use Neos\ContentRepository\Domain\Projection\Content\NodeInterface;
use Neos\ContentRepository\Domain\Projection\Content\TraversableNodeInterface;
use Neos\Eel\ProtectedContextAwareInterface;
use Neos\Flow\Annotations as Flow;
use Neos\Flow\Http\Request;
use Neos\Flow\Mvc\ActionRequest;
use Newland\Toubiz\Map\Neos\Provider\Contract\ProviderContext;
use Newland\Toubiz\Map\Neos\Provider\DefaultProviders\NodeBasedFilterItems;
use Newland\Toubiz\Map\Neos\Provider\MapDataProviderService;

class MapDataProviderHelper implements ProtectedContextAwareInterface
{

    /**
     * @var MapDataProviderService
     * @Flow\Inject()
     */
    protected $mapDataProvider;

    /**
     * @param ActionRequest|Request $request
     */
    public function getMarkers(Node $node, $request): array
    {
        if ($request instanceof ActionRequest) {
            $request = $request->getHttpRequest();
        }
        $mapNode = $this->mapDataProvider->getMapNode($node);
        if ($mapNode instanceof Node) {
            return $this->mapDataProvider->getMarkers(new ProviderContext($mapNode, $request));
        }
        return [];
    }

    public function markersForSubnode(Node $node): array
    {
        return $this->mapDataProvider->markersForSubnode($node);
    }

    /**
     * @param ActionRequest|Request $request
     */
    public function getFilterItems(Node $node, $request): array
    {
        if ($request instanceof ActionRequest) {
            $request = $request->getHttpRequest();
        }
        $mapNode = $this->mapDataProvider->getMapNode($node);
        if ($mapNode instanceof Node) {
            return $this->mapDataProvider->getFilterItems(new ProviderContext($mapNode, $request));
        }
        return [];
    }


    public function allowsCallOfMethod($methodName)
    {
        return $methodName === 'getMarkers' || $methodName === 'getFilterItems' || $methodName === 'markersForSubnode';
    }
}
