<?php
namespace Newland\Toubiz\Map\Neos;
use Neos\Flow\Command\CacheCommandController;
use Neos\Flow\Core\Bootstrap;
use Neos\Flow\Package\Package as BasePackage;
use Neos\Flow\SignalSlot\Dispatcher;
use Newland\Toubiz\Map\Neos\Command\MapCommandController;


class Package extends BasePackage
{

    public function boot(Bootstrap $bootstrap)
    {
        $this->connectSignalSlots($bootstrap->getSignalSlotDispatcher());
    }

    private function connectSignalSlots(Dispatcher $dispatcher)
    {
        $dispatcher->connect(
            CacheCommandController::class,
            'warmupCaches',
            MapCommandController::class,
            'buildArticleCacheCommand'
        );
    }
}