# toubiz-map package for Neos CMS.

This package provides functionality for integrating the Toubiz Map in Neos.


## Configuration

The following shows an example configuration of the map package:
Note, that valid values for icons are files found in the `Resources/Private/Icons`
directory.

```
Newland:
  Toubiz:
    Map:
      Neos:

        apiKeys:
          default:
            googleMaps: 'ABCDEF'
          sites:
            'skiarena-ch':
              googleMaps: '123456'

        toursprung:
          enableGoogleMapsSatelliteLayer: true

        clustering:
          color: '#f00'
          backgroundColor: '#00f'

        markers:
          defaultIcons:
            color: '#ff0'
            backgroundColor: '#777'
            icon: circle

            # Default icons for articles by main type
            # All article main type values can be found in the following class:
            # Newland\Toubiz\Api\ObjectAdapter\Concern\ArticleConstants
            mainType:
              # Gastronomy
              1:
                icon: restaurant
                color: '#000000'
                backgroundColor: '#ff8'

        location:
          staticMap:
            mapType: 'google-maps'
            width: 1024
            height: 400
            zoom: 15
            style:
              icon: 'circle-solid'
              color: '#fff'
              backgroundColor: 'red'
            srcSet:
              # The maximum value for with and height for google maps is 640
              - width: 640
                height: 400
                query: '(max-width: 768px)'
```


## Node-Based map editing starting in 1.14

Stating with the 1.14 release the concept of how maps are added and edited on the map. Previously, a statically
configured list of map categories have been added as configuration which would then automatically be used when
rendering the map. While this provided a low barrier of entry it was also quite limited as it relied on having
a single, predefined structure for all maps across all sites.

Instead of having a predefined, static list of categories this new version of the map package abolishes the
concept of a static category mapping in favour of allowing the editor to create a map that is completely custom.
While this means that adding a map to the site is slightly harder than before this also has a high potential
for displaying data in many different ways that was not possible before.

### Common Wording

To clear up confusion when reading about the new version of this package there have been a couple of terms
defined in the package:

- A **Filter Item** is an entry in the sidebar of the map, allowing the user to click on it to filter the map. A Filter Items
  job is solely providing structure.
- A **Marker Node** provides the actual information about (one or more) markers on the map. Marker nodes can be filtered articles,
  single articles, selected pages or internal and external links.

### Creating a custom map

To create a custom the editor can create filter items and marker nodes as subnodes of the map node.
The backend will provide a listing of the contents whereas the frontend will contain an actual map.

An example node tree could look like the following:

- Map
    - FilterItem "Restaurant"
        - FilterItem "Bayrische Originale"
            - FilteredArticles "category=..."
        - FilterItem "Schnelle Küche"
            - FilteredArticles "category=..."
        - FilterItem "Specials"
            - FilteredArticles "tag=special"
            - Link "Page ..."
            - Link "Page ..."
            - Link "https://special-restaurant.de"
        - FilterItem "Our Highlights"
            - SelectedPages "Page1, Page2, Page3, ..."

### Static maps for Location node type
The provider for the static map in the Location node type can be configured to either `google-maps` or
`toursprung` at `Newland.Toubiz.Map.Neos.location.staticMap.mapType`. In order to use static maps
in your project you have to have the api keys for the selected map type defined.

Other options for static map rendering such as width, height and zoom level can also be configured
under `Newland.Toubiz.Map.Neos.location.staticMap` if the default values do not fit the design.
For reference, see the example above.
