<?php declare(strict_types=1);

namespace Newland\Toubiz\Map\Neos\Tests\Unit\Serialization\Markers;

use Neos\ContentRepository\Domain\Model\Node;
use Neos\Flow\Tests\FunctionalTestCase;
use Neos\Neos\Domain\Model\Site;
use Newland\NeosTestingHelpers\InteractsWithNodes;

class MarkerSerializerTestCase extends FunctionalTestCase
{
    use InteractsWithNodes;
    protected static $testablePersistenceEnabled = true;

    /** @var Node */
    protected $node;

    /** @var Node */
    protected $filterItem;

    /** @var Site */
    protected $site;

    public function setUp(): void
    {
        parent::setUp();

        // Building the following structure:
        // Site root
        //  |> Site index page
        //    |> Map
        //      |> Filter Item
        $this->site = $this->initializeSite('foo');
        $nodes = $this->nodes([
              '/sites/foo' => [ 'nodeType' => 'Neos.NodeTypes:Page' ],
              '/sites/foo/main' => [ 'nodeType' => 'Neos.Neos:ContentCollection' ],
              '/sites/foo/main/map' => [ 'nodeType' => 'Newland.Toubiz.Map.Neos:Map' ],
              '/sites/foo/main/map/children' => [ 'nodeType' => 'Neos.Neos:ContentCollection' ],
              '/sites/foo/main/map/children/filter-item' => [ 'nodeType' => 'Newland.Toubiz.Map.Neos:Map.FilterItem' ],
              '/sites/foo/main/map/children/filter-item/children' => [ 'nodeType' => 'Neos.Neos:ContentCollection' ],
          ], [
              'workspaceName' => 'live',
              'site' => $this->site,
              'language' => 'de',
          ]);
        $this->node = $nodes['/sites/foo'];
        $this->filterItem = $nodes['/sites/foo/main/map/children/filter-item'];
    }

    protected function assertIsValidSerializedMarker($marker): void
    {
        $this->assertIsArray($marker);

        // Required fields
        $this->assertIsArray($marker['paths']);
        $this->assertIsString($marker['paths'][0]);
        $this->assertIsString($marker['title']);
        $this->assertIsArray($marker['coordinates']);

        // Optional keys
        $this->assertTrue(\is_string($marker['outdoorActiveTrackingId']) || $marker['outdoorActiveTrackingId'] === null);
        $this->assertTrue(\is_string($marker['categoryTitle']) || $marker['categoryTitle'] === null);
        $this->assertTrue(\is_string($marker['url']) || $marker['url'] === null);
        $this->assertTrue(\is_array($marker['image']) || $marker['image'] === null);
        if (\is_array($marker['image'])) {
            $this->assertIsString($marker['image']['url']);
            $this->assertIsString($marker['image']['alt']);
        }
        $this->assertTrue(\is_array($marker['defaultStyle']) || $marker['defaultStyle'] === null);
        $this->assertTrue(\is_array($marker['tour']) || $marker['tour'] === null);
        if (\is_array($marker['image'])) {
            $this->assertIsArray($marker['image']['polygon']);
        }
    }

}
