<?php declare(strict_types=1);

namespace Newland\Toubiz\Map\Neos;

use Neos\ContentRepository\Domain\Service\PublishingService;
use Neos\Flow\Core\Bootstrap;
use Neos\Flow\Package\Package as BasePackage;
use Neos\ContentRepository\Domain\Model\Node;
use Newland\Toubiz\Map\Neos\Serialization\NodeSlot;

class Package extends BasePackage
{

    public function boot(Bootstrap $bootstrap): void
    {
        $dispatcher = $bootstrap->getSignalSlotDispatcher();

        $dispatcher->connect(
            PublishingService::class,
            'nodePublished',
            NodeSlot::class,
            'onNodePublished'
        );
        $dispatcher->connect(
            Node::class,
            'nodePropertyChanged',
            NodeSlot::class,
            'onNodePropertyChanged'
        );
        $dispatcher->connect(
            Node::class,
            'nodePathChanged',
            NodeSlot::class,
            'onNodePathChanged'
        );
    }
}
