<?php declare(strict_types=1);

namespace Newland\Toubiz\Map\Neos\Controller;

use Neos\ContentRepository\Domain\Model\Node;
use Neos\Flow\Mvc\Controller\ActionController;
use Neos\Flow\Annotations as Flow;
use Newland\Toubiz\Map\Neos\Serialization\SerializationService;
use function Safe\json_encode;

class ApiController extends AbstractActionController
{
    protected $mimeType = 'application/json';

    /**
     * @var SerializationService
     * @Flow\Inject()
     */
    protected $serializationService;

    protected function handleError(\Throwable $throwable): void
    {
        $this->response->setStatusCode(500);
        $this->response->setContent(
            json_encode(
                [
                    'error' => [
                        'code' => $throwable->getCode(),
                        'file' => $throwable->getFile(),
                        'line' => $throwable->getLine(),
                        'message' => $throwable->getMessage(),
                        'trace' => $throwable->getTrace(),
                    ],
                ]
            )
        );
    }

    public function markerListAction(Node $node): string
    {
        return json_encode($this->serializationService->serializeAndCacheMarkers($node));
    }

    public function filterItemListAction(Node $node): string
    {
        return json_encode($this->serializationService->serializeAndCacheFilterItems($node));
    }
}
