<?php declare(strict_types=1);

namespace Newland\Toubiz\Map\Neos\DataSource;

use Neos\ContentRepository\Domain\Model\NodeInterface;
use Neos\Flow\I18n\Locale;
use Neos\Flow\I18n\Translator;
use Neos\Neos\Service\DataSource\AbstractDataSource;
use Neos\Flow\Annotations as Flow;

class ToursprungMapStyleDataSource extends AbstractDataSource
{
    protected static $identifier = 'newland-toubiz-map-neos-tourprung-map-style';

    /**
     * @var Translator
     * @Flow\Inject()
     */
    protected $translator;

    /**
     * @var array
     * @Flow\InjectConfiguration(package="Newland.Toubiz.Map.Neos", path="toursprung")
     */
    protected $settings;

    public function getData(NodeInterface $node = null, array $arguments)
    {
        $language = $node ? ($node->getDimensions()['language'][0] ?? null) : null;
        $locale = null;
        if ($language) {
            $locale = new Locale($language);
        }

        $styles = [
            $this->property('light', $locale),
            $this->property('opencyclemap', $locale),
            $this->property('terrain_bw', $locale),
            $this->property('terrain_v3', $locale),
            $this->property('terrain_winter', $locale),
        ];

        if ($this->settings['enableGoogleMapsSatelliteLayer'] ?? false) {
            $styles[] = $this->property('google_satellite', $locale);
        }

        return $styles;
    }

    private function property(string $value, ?Locale $locale): array
    {
        $label = $this->translator->translateById(
            'properties.toursprungMapStyle.selectBoxEditor.values.' . $value,
            [],
            null,
            $locale,
            'NodeTypes/Map',
            'Newland.Toubiz.Map.Neos'
        );
        return [ 'label' => $label, 'value' => $value ];
    }
}
