<?php
namespace Newland\Toubiz\Map\Neos\Controller;

/*
 * This file is part of the "toubiz-map-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\Flow\Annotations as Flow;
use Neos\Flow\Mvc\Controller\ActionController;
use Newland\Toubiz\Sync\Neos\Domain\Repository\ArticleRepository;
use Newland\Toubiz\Sync\Neos\Domain\Repository\CategoryRepository;

/**
 * Map controller.
 *
 * @Flow\Scope("singleton")
 */
class MapController extends ActionController
{
    /**
     * @Flow\InjectConfiguration
     * @var array
     */
    protected $configuration;

    /**
     * @var ArticleRepository
     * @Flow\Inject
     */
    protected $articleRepository;

    /**
     * @var CategoryRepository
     * @Flow\Inject
     */
    protected $categoryRepository;

    /**
     * Show action.
     *
     * Displays the map.
     *
     * @return void
     */
    public function showAction()
    {
        $this->view->assignMultiple([
            'configuration' => $this->configuration,
            'properties' => $this->request->getInternalArgument('__node')->getProperties(),

            'nodes' => $this->request->getInternalArgument('__mapNodes'),
            'articles' => $this->articleRepository->findAll(),
            'categories' => $this->categoryRepository->findAll()
        ]);
    }
}
