<?php
namespace Newland\Toubiz\Map\Neos\Controller;

/*
 * This file is part of the "toubiz-map-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\Flow\Annotations as Flow;
use Neos\Flow\Mvc\Controller\ActionController;

/**
 * Map controller.
 *
 * @Flow\Scope("singleton")
 */
class MapController extends ActionController
{
    /**
     * @Flow\InjectConfiguration
     * @var array
     */
    protected $configuration;

    /**
     * Show action.
     *
     * Displays the map.
     *
     * @return void
     */
    public function showAction()
    {
        $this->view->assignMultiple([
            'nodes' => $this->request->getInternalArgument('__mapNodes'),
            'configuration' => $this->configuration,
            'properties' => $this->request->getInternalArgument('__node')->getProperties()
        ]);
    }
}
