<?php
namespace Newland\Toubiz\Events\Neos\ViewHelpers\Widget\Controller;

/*
 * This file is part of the "toubiz-events-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\ContentRepository\Domain\Model\NodeInterface;
use Neos\Flow\Annotations as Flow;
use Neos\FluidAdaptor\Core\Widget\AbstractWidgetController;
use Newland\NeosCommon\Service\NodeService;
use Newland\Toubiz\Events\Neos\Filter\EventDateFilterFactory;

class HighlightsController extends AbstractWidgetController
{

    /**
     * @var array
     * @Flow\InjectConfiguration(package="Newland.Toubiz.Events.Neos", path="filter")
     */
    protected $filterConfiguration;

    /**
     * @var NodeService
     * @Flow\Inject()
     */
    protected $nodeService;

    /** @var NodeInterface */
    protected $node;

    public function setNode(NodeInterface $node): void
    {
        $this->node = $node;
    }

    public function indexAction(): void
    {
        $this->request->setArgument('__node', $this->node);
        $overrides = (array) array_replace((array) $this->node->getProperties(), [ 'filterHighlights' => true ]);
        $eventDates = (new EventDateFilterFactory($this->widgetConfiguration['node']))
            ->createEventFilter($this->filterConfiguration, $overrides)
            ->initializeForFilteredLists($this->request)
            ->getEventQuery()
            ->getQuery()
            ->execute();

        $this->view->assignMultiple(
            [
                'currentDate' => new \DateTime(),
                'eventDates' => $eventDates,
                'node' => $this->node,
                'documentNode' => $this->nodeService->getDocumentNode($this->node),
            ]
        );
    }
}
