<?php

namespace Newland\Toubiz\Events\Neos\DataSource;

/*
 * This file is part of the "toubiz-poi-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\ContentRepository\Domain\Model\NodeInterface;
use Neos\Flow\Annotations as Flow;
use Neos\Flow\I18n\Translator;
use Neos\Neos\Service\DataSource\AbstractDataSource;
use Newland\NeosCommon\Domain\Model\Topic;
use Newland\Toubiz\Events\Neos\Domain\Repository\TopicRepository;

/**
 * Categories data source service.
 *
 * @Flow\Scope("singleton")
 */
class TopicsDataSource extends AbstractDataSource
{
    /**
     * Data source identifier.
     *
     * @var string
     */
    protected static $identifier = 'newland-toubiz-events-neos-topics';

    /**
     * @var Translator
     * @Flow\Inject
     */
    protected $translator;

    /**
     * @var TopicRepository
     * @Flow\Inject
     */
    protected $topicRepository;

    /**
     * Get requested data from source.
     *
     * The return value must be JSON serializable data structure.
     *
     * @api
     * @param NodeInterface $node The node that is currently edited (optional)
     * @param array $arguments Additional arguments (key / value)
     * @return mixed JSON serializable data
     * @throws \Neos\ContentRepository\Exception\NodeException
     */
    public function getData(NodeInterface $node = null, array $arguments = [])
    {
        $groups = [
            TopicRepository::TYPE_TAG => $this->translate('type.tag'),
            TopicRepository::TYPE_CATEGORY => $this->translate('type.categories'),
        ];

        $topics = $this->topicRepository->findAll();

        return array_map(
            function (Topic $topic) use ($groups) {

                return [
                    'label' => $topic->getTitle(),
                    'value' => $topic->getCombinedIdentifier(),
                    'group' => $groups[$topic->getType()],
                ];
            },
            $topics
        );
    }

    /**
     * @param string $id
     * @return string|null
     */
    private function translate(string $id)
    {
        return $this->translator->translateById(
            $id,
            [],
            null,
            null,
            'Models/Topic',
            'Newland.Toubiz.Poi.Neos'
        );
    }
}
