<?php
namespace Newland\Toubiz\Events\Neos\ViewHelpers\Filter;

/*
 * This file is part of the "toubiz-poi-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\FluidAdaptor\Core\ViewHelper\AbstractViewHelper;
use Newland\NeosCommon\Domain\Model\Topic;

/**
 * Builds a `name` attribute string for the given topic.
 * - If `dotNotation` is set to `true` then the returned name is in dot notation (e.g. `foo.bar.baz`)
 *   (as required by `<f:form.* property=` attributes.
 * - If `dotNotation` is set to `false` then a URL-query segment is built (e.g. `[foo][bar][baz]`)
 *   (as required by manual form requests).
 * - `appendValueIfExists` can be used to specify whether or not the value of the topic should be
 *   appended as the last item of the returned name.
 */
class NameViewHelper extends AbstractViewHelper
{

    public function render(Topic $topic, $dotNotation = true, bool $appendValueIfExists = true)
    {
        $query = QueryViewHelper::queryPathForTopic($topic, $appendValueIfExists);

        if ($dotNotation) {
            return $this->queryToDotNotation($query);
        }
        return $this->queryToUrlNotation($query);
    }

    private function queryToDotNotation(array $query): string
    {
        return implode('.', $query);
    }

    private function queryToUrlNotation(array $query): string
    {
        $queryWithBrackets = '';
        foreach ($query as $part) {
            $queryWithBrackets .= sprintf('[%s]', $part);
        }

        return $queryWithBrackets;
    }
}
