<?php
namespace Newland\Toubiz\Events\Neos\ViewHelpers\Link;

/*
 * This file is part of the "toubiz-events-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use DateTime;
use Neos\ContentRepository\Domain\Model\Node;
use Neos\ContentRepository\Domain\Model\NodeInterface;
use Neos\ContentRepository\TypeConverter\NodeConverter;
use Neos\Flow\Mvc\ActionRequest;
use Neos\Flow\Utility\Now;
use Neos\FluidAdaptor\Core\ViewHelper\AbstractTagBasedViewHelper;
use Neos\Flow\Annotations as Flow;
use Neos\Neos\Domain\Service\ContentContext;
use Newland\Toubiz\Events\Neos\Service\EventUrlService;
use Newland\Toubiz\Sync\Neos\Domain\Model\Event;

class EventViewHelper extends AbstractLinkViewHelper
{
    public function render(Event $event = null, Node $currentNode = null): string
    {
        if (!$event) {
            return $this->isInBackend() ? 'Error: No event specified.' : '';
        }

        if ($this->isExpired($event)) {
            return $this->isInBackend() ?
                'Error: The event has expired at ' . $event->getEndsAt()->format('Y-m-d H:i:s') :
                '';
        }

        $this->tag->addAttribute('href', $this->generateUrl($event, null, $currentNode));
        $this->tag->setContent($this->renderChildren());
        return $this->tag->render();
    }

    private function isExpired(Event $event): bool
    {
        $today = new DateTime();
        return $event->getEndsAt() < $today &&
            ($event->getBeginsAt()->format('Y-m-d H:i:s') !== $event->getEndsAt()->format('Y-m-d H:i:s'));
    }
}
