<?php
namespace Newland\Toubiz\Events\Neos\Filter\Items;

/*
 * This file is part of the "toubiz-events-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\Flow\Annotations as Flow;
use Newland\NeosFiltering\Items\CheckboxList;
use Newland\Toubiz\Poi\Neos\Service\RegionService;

class RegionList extends CheckboxList
{
    /**
     * @var RegionService
     * @Flow\Inject()
     */
    protected $regionService;

    protected function getStateValuesForQuery(): array
    {
        $identifiers = $this->getStateValues();

        if (empty($identifiers)) {
            return [];
        }

        return $this->regionService->collectZipsFromRegionKeys($identifiers, true);
    }
}
