<?php
namespace Newland\Toubiz\Events\Neos\Controller;

/*
 * This file is part of the "toubiz-events-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\Flow\Annotations as Flow;
use Newland\Toubiz\Events\Neos\Filter\EventDateFilterFactory;
use Newland\Toubiz\Sync\Neos\Domain\Model\Event;
use Newland\Toubiz\Sync\Neos\Domain\Repository\EventRepository;

class EventsController extends AbstractActionController
{
    /**
     * @var EventRepository
     * @Flow\Inject()
     */
    protected $eventRepository;

    public function teaserAction(): void
    {

        $this->view->assignMultiple(
            [
                'event' => $this->eventRepository->findByIdentifier($this->properties['event'] ?? ''),
                'wrapStart' => $this->request->getInternalArgument('__wrapStart'),
                'wrapEnd' => $this->request->getInternalArgument('__wrapEnd'),
            ]
        );
    }

    /**
     * Teaser List action.
     *
     * Lists a subset of upcoming events.
     *
     * @return void
     */
    public function teaserListAction(): void
    {
        $today = (new \DateTime())->format('Y-m-d');

        $this->properties['numberOfDays'] = $this->getDateIntervalForTeaserList($this->properties['numberOfDays'] ?? 1);
        $filter = (new EventDateFilterFactory($this->node))
            ->createEventFilter($this->settings['filter'], $this->properties)
            ->initializeForFilteredLists($this->request);

        $eventDates = $filter
            ->getEventQuery()
            ->setMaxResults($this->properties['recordLimit'])
            ->getQuery()
            ->execute();

        $this->view->assignMultiple(
            [
                'wrapStart' => $this->request->getInternalArgument('__wrapStart'),
                'wrapEnd' => $this->request->getInternalArgument('__wrapEnd'),
                'currentDate' => $today,
                'eventDates' => $eventDates,
            ]
        );
    }
    private function getDateIntervalForTeaserList($numberOfDays = 1): array
    {
        $modify = \Safe\sprintf('+%d days', max(0, $numberOfDays - 1));
        $lastDay = (clone $this->now)->modify($modify);

        return [
            'from' => $this->now->format('Y-m-d'),
            'to' => $lastDay->format('Y-m-d'),
        ];
    }

    /**
     * @param Event $event
     * @return void
     */
    public function showAction(Event $event = null): void
    {
        if (!$event) {
            return;
        }

        $this->view->assign('event', $event);
    }
}
