# Changelog
All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

## [1.15.0] - 2019-12-05
### Fixed
- Don't display empty teaser wrappers in front end if event is expired
- The "details" tab in the detail view is now shown for events that only have additional information or a link without having an associated organizer or features.

### Actions Required
#### For every environment
Reminder about depreciated content, please check [1.13.0] entry
- The `20190906111427` can be used in order to migrate from the `Newland.Toubiz.Events.Neos:Full` node type
  to the new `Newland.Toubiz.Events.Neos:List`. This migration will preserve your pre-filtering settings
  as best as possible.
  - If you had setup topics to be displayed under the filter, they will not be migrated: There now is a content
    area in the backend that can be used to add more detailed list links. You will have to manually re-add these
    topic buttons.
  - If you had the `integrationType` setting set to `point` [an option that was only used very rarely], then
    you may notice, that events lists do no longer display todays events in their own section. In this case you
    will have to manually set the according checkbox in the node properties of the list.
- After running the node migration you must also run `node:repair` to ensure that properties and children are
  created correctly.

## [1.14.5] - 2019-11-20
### Fixed
- Fixed event detail views not displaying correct times for events with multiple dates
- Fixed lists not showing events that started earlier that day and full-day events for today.
- Fixed canonical URL in events detail views pointing to the home page.
    - Please ensure that you are using the new `Newland.NeosMetaTags:CanonicalLink` in your page fusion.
- Fixed 'events today' list not formatting dates correctly
- Progressbar when regenerating all event urls now has a correct maximum value.

## [1.14.4] - 2019-10-02
- Restored previous `ViewHelpers\Widget\TeaserViewHelper` to it's new location in
  `PublicViewHelpers\Widget\SimplisticTeaserListViewHelper`.

## [1.14.0] - 2019-09-17
### Changed
- Nodetype TeaserList now includes all the new filter logic. Added a new Node migration to correctly
handle the old logic, see Action required section
- Adjust existing `img` tags to use lazy loading.
- New node type `ListLink` added, that links to a prefiltered list. This can be inserted at a fixed
  position within the full view plugin.

### Added
- New NodeType 'List' displays a filtered list using the new filter logic.

### Fixed
- Fixed events displaying default starting and end times at 00:00.
- Fixed recurring events in `Toubiz Events: Full` upcoming highlight section
  are not showing the date of a past event anymore.
- Highlighted events now are sorted by the next occurrence of the event
  rather than the first time the event takes place.
- Events are not displayed if they are expired.
- The `Newland.Toubiz.Events.Neos:Full` node type has been removed in favour of the newer
  `Newland.Toubiz.Events.Neos:List`. For migration information check the 'Actions Required'
  section.

### Removed
- The `integrationType` setting has been removed in favour of checkboxes of the new
  `Newland.Toubiz.Events.Neos:List` node type. For migration information check the 'Actions Required'
  section.

### Actions Required
#### For every environment
The following actions must be executed on every environment after the update is first deployed to.
This means, that these steps must be executed on every development machine, after deploying to preview and
after deploying to live. Not executing these steps after a deployment may lead to an undefined state that
can cause errors or corrupt data!

- The `20190906111427` can be used in order to migrate from the `Newland.Toubiz.Events.Neos:Full` node type
  to the new `Newland.Toubiz.Events.Neos:List`. This migration will preserve your pre-filtering settings
  as best as possible.
  - If you had setup topics to be displayed under the filter, they will not be migrated: There now is a content
    area in the backend that can be used to add more detailed list links. You will have to manually re-add these
    topic buttons.
  - If you had the `integrationType` setting set to `point` [an option that was only used very rarely], then
    you may notice, that events lists do no longer display todays events in their own section. In this case you
    will have to manually set the according checkbox in the node properties of the list.
- After running the node migration you must also run `node:repair` to ensure that properties and children are
  created correctly.

## [1.13.1] - 2019-08-13
### Fixed
- Fixed events lists not being displayed because of missing viewhelpers.

## [1.13.0] - 2019-08-01
### Changed
- Teaser lists now have more extensive filter options

### Action required
- You will need to execute the node migration `20190728171500` in order to migrate the previous
  preselected regions to the new ones.

```bash
$ php flow node:migrate --version 20190728171500
```

- You will need to execute the node migration `20190822142000` in order to migrate the previous
  preselectedTopics in TeaserLists to the new filter logic.

```bash
$ php flow node:migrate --version 20190822142000
```

## [1.12.4] - 2019-07-23
### Fixed
- Fixed links not being overwritten by the configuration to redirect to TPortal.
- Fixed filtering error while applying filters to lists.

## [1.12.3] - 2019-07-22
### Changed
- Event urls can now be overwritten to point to TPortal detail pages by addind the configuration:
```yaml
Newland:
  Toubiz:
    Events:
      Neos:
        detailPages:
          clients:
            Default:
              redirectToTportal: true
              detailUri: 'https://www.bodenseewest.eu/westlicherbodensee/event/detail/{name}-{id}'
            Radolfzell:
              redirectToTportal: true
              detailUri: 'https://www.radolfzell-tourismus.de/radolfzell/event/detail/{name}-{id}'
```
## [1.12.0] - 2019-07-12
### Added
- It is now possible to create a shortcut node pointing to an event detail page.

## [1.11.2] - 2019-06-28
### Fixed
- Fixed event lists breaking when after adding in backend

## [1.10.4] - 2019-06-21
### Fixed
- Added time to the event toDate property as 23:59:59 needed for the query and the datepicker
behaviour to show it is selected when the to and from date are equal.

## [1.10.2] - 2019-06-19
### Added
- Breadcrumb configuration can now be defined on a per-site basis using the
  articles node name as a key. For more information please refer to `README.md`.
  Existing configuration will continue working for now but support for it will be
  removed with the next release. Please update your breadcrumb configuration to use
  keys under `breadcrumb` (at least use `_fallback` if you don't differentiate between)
  sites.


```yaml
# Before:
Newland:
  Toubiz:
    Events:
      Neos:
        detailPage:
          _fallback:
            breadcrumb:
              - '/sites/foobar-theme/node-abc123def'
              - '/sites/foobar-theme/node-abc123def/node-49494949'

# After
Newland:
  Toubiz:
    Events:
      Neos:
        detailPage:
          _fallback:
            breadcrumb:
              _fallback:
                - '/sites/foobar-theme/node-abc123def'
                - '/sites/foobar-theme/node-abc123def/node-49494949'
              # Site specific breadcrumbs can be added here.
```


## [1.10.0] - 2019-06-07
### Changed
- Events Teaser List node is now correctly named TeaserList
- Events can now be associated to a teaser. Implementation follows the same as POI teasers.
- Displays button for more events only when there are additional events to be shown.
- Link to e.g. external event detail pages can now be build. Take a look to `Newland.Toubiz.Sync.Neos` README for an example.
- Teaser list node type now uses regions as preselected filter, instead of zip codes.

### Fixed
- Detail URLs now contain a unique identifier. This prevents multiple records with the same title from
  having `-1` appended to them. Requests to the old detail URLs will be redirected accordingly.

## [1.7.2] - 2019-05-17
### Changed
- Scope name of event indexer has been changed to `toubiz_events`
- EventIndexer is now compatible with Search 1.1.0

### Potentially breaking
- This package now requires Search 1.1.0 or later

## [1.7.1] - 2019-05-09
### Added
- Hook to build events URLs on sync

## [1.7.0] - 2019-05-08
### Fixed
- Datepicker filter now works on index view.
- Filtering by regions in frontend.

## [1.6.1] - 2019-04-18
### Fixed
- Updated `newland/neos-viewhelpers` to a minimum of `1.3.0`
- Fixed rendering of line breaks in additionalInformation and ticket contact

## [1.6.0] - 2019-04-17
### Added
- Ticket contact information, event link and additional information are now
  displayed in detail view.

### Changed
- Dependency to toubiz-search-neos is now versions instead of a specific feature branch.
- Guest card info is now displayed under price info.

### Fixed
- Prefiltered regions now work on multiple elements.


## [1.5.0] - 2019-04-04
### Added
- LinkHandler support is now bundled by default.
- Breadcrumb support for detail pages
- Integration for `Newland.Toubiz.Search.Neos` has been added
- New Filterbar (similar to POI Tours) has been added
- Prefiltering by regions in the backend

### Migration Notes
- If you project has Linkhandler configuration (In `Newland.NeosCommon.linkhandler`)
  for Events under the name `event` then that configuration can be safely removed.


## [1.4.1] - 2019-03-08
- No functional changes

## [1.4.0] - 2019-03-08
### Added
- A new `Newland.Toubiz.Event.findByIdentifier` fusion helper has been added.
- Detail pages are now rendered using neos-pageframeprovider

### Changed
- All Events plugins are located in one group in the backend interface
- Now uses target-enhancement 2.0 compatible markup

### Migration Notices
- Be sure to include the `newland/page-frame-provider` repository in your projects `composer.json`
