<?php declare(strict_types=1);

namespace Newland\Toubiz\Events\Neos\Tests\Integration;

class TeaserTest extends IntegrationTestCase
{
    public function setUp(): void
    {
        parent::setUp();
        $this->node->setNodeType($this->nodeTypeManager->getNodeType('Newland.Toubiz.Events.Neos:Teaser'));
        $this->persistNode($this->node);
    }

    public function testDoesNotThrowError(): void
    {
        $tomorrow = (new \DateTime())->add(new \DateInterval('P1D'));
        $dateTomorrow = $this->eventFactory->create([ 'title' => 'DATE_TOMORROW' ]);
        $this->eventDateFactory->create([ 'beginsAt' => $tomorrow, 'endsAt' => (clone $tomorrow)->add(new \DateInterval('PT1H')), 'event' => $dateTomorrow ]);

        $this->node->setProperty('event', $dateTomorrow->getPersistenceObjectIdentifier());
        $this->persistNode($this->node);

        $response = $this->browser->request($this->nodeUri);
        $this->assertResponseOk($response);
    }

}
