<?php declare(strict_types=1);

namespace Newland\Toubiz\Events\Neos\Tests\Integration;

use Newland\Toubiz\Events\Neos\Service\EventUrlService;
use Newland\Toubiz\Sync\Neos\Domain\Model\Event;
use Newland\Toubiz\Sync\Neos\Tests\Factory\EventDateFactory;
use Newland\Toubiz\Sync\Neos\Tests\Factory\EventFactory;

class IntegrationTestCase extends \Newland\NeosTestingHelpers\IntegrationTestCase
{

    /** @var EventFactory */
    protected $eventFactory;

    /** @var EventDateFactory */
    protected $eventDateFactory;

    /** @var EventUrlService */
    protected $eventUrlService;

    public function setUp(): void
    {
        parent::setUp();
        $this->eventFactory = new EventFactory($this->objectManager);
        $this->eventDateFactory = new EventDateFactory($this->objectManager);
        $this->eventUrlService = $this->objectManager->get(EventUrlService::class);
    }

}
