<?php
namespace Newland\Toubiz\Events\Neos\Service;

use Newland\Toubiz\Events\Neos\Encoder\TopicsToQueryEncoder;
use Neos\Flow\Annotations as Flow;

/**
 * Simple helper that encapsulates the ability to have some overrides defined in
 * node properties that are then applied to a given query.
 *
 * This is used in order to add pre-filtering of lists based on editor selection.
 *
 * @Flow\Scope("prototype")
 */
class QueryOverride
{

    /** @var array */
    protected $override = [];

    /**
     * @var TopicsToQueryEncoder
     * @Flow\Inject()
     */
    protected $topicsToQueryEncoder;

    public function initialize(array $properties): void
    {
        $preselectedTopics = (array) ($properties['preselectedTopics'] ?? []);
        $this->override = $this->topicsToQueryEncoder->encode($preselectedTopics);

        $preselectedRegions = (array) ($properties['preselectedRegions'] ?? []);
        if (!empty($preselectedRegions)) {
            $this->override = array_merge($this->override, [ 'preselectedRegions' => $preselectedRegions ]);
        }

        $eventScope = (array) ($properties['eventScope'] ?? []);
        if (!empty($eventScope)) {
            $this->override = array_merge($this->override, [ 'eventScope' => $eventScope ]);
        }
    }

    public function computeDemandFromQuery(array $query): array
    {
        $demand = array_replace_recursive($this->override, $query);

        // Treat empty strings as non-existent
        return array_filter(
            $demand,
            function ($value) {
                return $value !== '';
            }
        );
    }


    public function getOverride(): array
    {
        return $this->override;
    }
}
