# Changelog
All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

## [1.10.2] - 2019-06-19
### Added
- Breadcrumb configuration can now be defined on a per-site basis using the
  articles node name as a key. For more information please refer to `README.md`.
  Existing configuration will continue working for now but support for it will be
  removed with the next release. Please update your breadcrumb configuration to use
  keys under `breadcrumb` (at least use `_fallback` if you don't differentiate between)
  sites.


```yaml
# Before:
Newland:
  Toubiz:
    Events:
      Neos:
        detailPage:
          _fallback:
            breadcrumb:
              - '/sites/foobar-theme/node-abc123def'
              - '/sites/foobar-theme/node-abc123def/node-49494949'

# After
Newland:
  Toubiz:
    Events:
      Neos:
        detailPage:
          _fallback:
            breadcrumb:
              _fallback:
                - '/sites/foobar-theme/node-abc123def'
                - '/sites/foobar-theme/node-abc123def/node-49494949'
              # Site specific breadcrumbs can be added here.
```


## [1.10.0] - 2019-06-07
### Changed
- Events Teaser List node is now correctly named TeaserList
- Events can now be associated to a teaser. Implementation follows the same as POI teasers.
- Displays button for more events only when there are additional events to be shown.
- Link to e.g. external event detail pages can now be build. Take a look to `Newland.Toubiz.Sync.Neos` README for an example.
- Teaser list node type now uses regions as preselected filter, instead of zip codes.

### Fixed
- Detail URLs now contain a unique identifier. This prevents multiple records with the same title from
  having `-1` appended to them. Requests to the old detail URLs will be redirected accordingly.

## [1.7.2] - 2019-05-17
### Changed
- Scope name of event indexer has been changed to `toubiz_events`
- EventIndexer is now compatible with Search 1.1.0

### Potentially breaking
- This package now requires Search 1.1.0 or later

## [1.7.1] - 2019-05-09
### Added
- Hook to build events URLs on sync

## [1.7.0] - 2019-05-08
### Fixed
- Datepicker filter now works on index view.
- Filtering by regions in frontend.

## [1.6.1] - 2019-04-18
### Fixed
- Updated `newland/neos-viewhelpers` to a minimum of `1.3.0`
- Fixed rendering of line breaks in additionalInformation and ticket contact

## [1.6.0] - 2019-04-17
### Added
- Ticket contact information, event link and additional information are now
  displayed in detail view.

### Changed
- Dependency to toubiz-search-neos is now versions instead of a specific feature branch.
- Guest card info is now displayed under price info.

### Fixed
- Prefiltered regions now work on multiple elements.


## [1.5.0] - 2019-04-04
### Added
- LinkHandler support is now bundled by default.
- Breadcrumb support for detail pages
- Integration for `Newland.Toubiz.Search.Neos` has been added
- New Filterbar (similar to POI Tours) has been added
- Prefiltering by regions in the backend

### Migration Notes
- If you project has Linkhandler configuration (In `Newland.NeosCommon.linkhandler`)
  for Events under the name `event` then that configuration can be safely removed.


## [1.4.1] - 2019-03-08
- No functional changes

## [1.4.0] - 2019-03-08
### Added
- A new `Newland.Toubiz.Event.findByIdentifier` fusion helper has been added.
- Detail pages are now rendered using neos-pageframeprovider

### Changed
- All Events plugins are located in one group in the backend interface
- Now uses target-enhancement 2.0 compatible markup

### Migration Notices
- Be sure to include the `newland/page-frame-provider` repository in your projects `composer.json`
