<?php
namespace Newland\Toubiz\Events\Neos\Utility;

/*
 * This file is part of the "toubiz-events-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\Flow\Annotations as Flow;

/**
 * DateTime utility.
 *
 * @Flow\Scope("singleton")
 */
class DateTimeUtility
{
    /**
     * Builds a DateTime object based on given params, or "today".
     *
     * @param int $year
     * @param int $month
     * @param int $day
     * @return \DateTime
     */
    public static function buildDateTimeObject(int $year = null, int $month = null, int $day = null): \DateTime
    {
        $dateTime = new \DateTime();
        $dateTime->setDate(
            $year ?? (int) date('Y'),
            $month ?? (int) date('m'),
            $day ?? (int) date('d')
        );

        return $dateTime;
    }
}
