<?php
namespace Newland\Toubiz\Events\Neos\LinkHandler;

use Newland\NeosCommon\LinkHandler\Domain\Model\Record;
use Newland\Toubiz\Sync\Neos\Domain\Model\Event;

class EventRecord extends Record
{
    /** @var Event */
    private $event;

    public function __construct(Event $event)
    {
        $this->event = $event;
        $this->setId($event->getPersistenceObjectIdentifier());

        $language = $event->getLanguage();
        if ($language !== null) {
            $this->setTitle(sprintf('[%s] %s', strtoupper($language), $event->getTitle()));
        } else {
            $this->setTitle($event->getTitle());
        }
    }

    public function getEvent(): Event
    {
        return $this->event;
    }
}
