<?php
namespace Newland\Toubiz\Events\Neos\Tests\Unit\Encoder;


use Neos\Flow\Tests\FunctionalTestCase;
use Newland\Toubiz\Events\Neos\Encoder\TopicsToQueryEncoder;

class TopicsToQueryEncoderTest extends FunctionalTestCase
{

    /** @var TopicsToQueryEncoder */
    private $subject;

    public function setUp()
    {
        parent::setUp();
        $this->subject = new TopicsToQueryEncoder();
    }

    public function testAddsCategoriesUsingIdentifierAsKey(): void
    {
        $encoded = $this->subject->encode([ 'category:abc-def' ]);
        $this->assertEquals([ 'categories' => [ 'abc-def' => 'abc-def' ] ], $encoded);
    }

    public function testAddsEventTagsUsingIdentifierAsKey(): void
    {
        $encoded = $this->subject->encode([ 'eventTag:foobar' ]);
        $this->assertEquals([ 'eventTags' => [ 'foobar' => 'foobar' ] ], $encoded);
    }

}
