<?php
namespace Newland\Toubiz\Events\Neos\ViewHelpers\Filter;

/*
 * This file is part of the "toubiz-poi-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\FluidAdaptor\Core\Widget\AbstractWidgetViewHelper;
use Neos\Flow\Annotations as Flow;
use Neos\FluidAdaptor\ViewHelpers\FormViewHelper;
use Newland\Toubiz\Events\Neos\ViewHelpers\Filter\Controller\FieldSetController;

/**
 * Renders the fields in the given fieldSet configuration.
 */
class FieldSetViewHelper extends AbstractWidgetViewHelper
{

    /**
     * @var FieldSetController
     * @Flow\Inject()
     */
    protected $controller;

    public function initializeArguments()
    {

        parent::initializeArguments();
        $this->registerArgument('fieldSet', 'array', 'Filter that should be rendered');
        $this->registerArgument('name', 'string', 'Name of the field set configuration');
        $this->registerArgument('node', 'object', 'The current node');
    }

    public function render(): string
    {
        $this->controller->passViewHelperVariables($this->viewHelperVariableContainer, [ FormViewHelper::class ]);

        $response = $this->initiateSubRequest();

        return (string) $response->getBody();
    }
}
