# Toubiz events package for Neos CMS.

This package provides functionality for integrating events from toubiz into Neos.

## Configuration

### Settings
The following settings must be provided in order to fetch data from toubiz:

```
Newland:
  Toubiz:
    Events:
      Neos:
        apiKey: '<API KEY>'
        client: '<CLIENT NAME>'
```

Optional:
`organizer` can be used to restrict API results to a certain event organizer.

### Overview page

The overview (full) plugin renders a paginated list of event dates with a filter bar on top.

The filter bar includes some default filters by default (e.g. categories, regions).

To remove default filter sections or field sets unset them in your project configuration:
```yaml
// hide a section
Newland:
  Toubiz:
    Events:
      Neos:
        filter:
          sections:
            regions: ~

// hide a field set
Newland:
  Toubiz:
    Events:
      Neos:
        filter:
          sections:
            categories:
              fieldSets:
                regions: ~
```

### Routing
For speaking urls, event sub routes must be registered in `Routes.yaml`:

```

-
  name: 'Events'
  uriPattern: '<EventsSubroutes>'
  subRoutes:
    'EventsSubroutes':
      package: 'Newland.Toubiz.Events.Neos'
```

#### Detail Page
The default path to the detail view is `/event/my-event-title` as defined in the settings:
```
Newland:
  Toubiz:
    Events:
      Neos:
        detailPage:
          _fallback: 
            uriSegment: event
            breadcrumb:
              _fallback:
                - '/sites/foobar-theme/node-abc123def'
                - '/sites/foobar-theme/node-abc123def/node-49494949'
              site-foobar:
                - '/sites/foobar-theme/node-def-456-fgi'
                - '/sites/foobar-theme/node-node-def456fgi/node-12121212'
```
Override this in the site package if needed.

#### Override detail pages
The default pages can be redirected to it's TPortal detail by adding the following settings:
 ```
 Newland:
   Toubiz:
     Events:
       Neos:
         detailPages:
           clients:
             Default:
               redirectToTportal: true
               detailUri: 'https://www.bodenseewest.eu/westlicherbodensee/event/detail/{name}-{id}'
             Radolfzell:
               redirectToTportal: true
               detailUri: 'https://www.radolfzell-tourismus.de/radolfzell/event/detail/{name}-{id}'
 ```

#### Expiring Days
The days an event is reachable after deactivation. Default value is 30 days.
```
Newland:
  Toubiz:
    Events:
      Neos:
        expireDays: 30
```

#### List links
To use the `ListLink` node type a target page for those links needs to be configured:
```
Newland:
  Toubiz:
    Events:A
      Neos:
        linkTargets:
          lists:
            default: 'node://4d8c8785-eae1-474a-9ecb-1775360246ab'
```

## Commands
The follwing commands are provided by this package:

 * `events:synchronize` to synchronize events between toubiz and the local database.

## ViewHelpers
Only ViewHelpers in the Namespace `Newland\Toubiz\Events\Neos\PublicViewHelpers` should be used by sites.
All ViewHelpers in other namespaces are private to this package and may change at any time without notice.
