<?php
namespace Newland\Toubiz\Events\Neos\Encoder;

use Newland\Toubiz\Events\Neos\Domain\Repository\TopicRepository;
use Neos\Flow\Annotations as Flow;

/**
 * @Flow\Scope("singleton")
 */
class TopicsToQueryEncoder
{
    /**
     * @param string[] $topicIdentifiers
     * @return array
     */
    public function encode(array $topicIdentifiers = []): array
    {
        $encoded = [];

        $typeRegex = $this->typeRegex([ TopicRepository::TYPE_TAG, TopicRepository::TYPE_CATEGORY ]);
        foreach ($topicIdentifiers as $combinedIdentifier) {
            if (!preg_match($typeRegex, $combinedIdentifier, $matches)) {
                continue;
            }

            switch ($matches['type']) {
                case TopicRepository::TYPE_CATEGORY:
                    $encoded = $this->addCategory($encoded, $matches['identifier']);
                    break;
                case TopicRepository::TYPE_TAG:
                    $encoded = $this->addTag($encoded, $matches['identifier']);
                    break;
            }
        }

        return $encoded;
    }

    private function addCategory(array $encoded, string $identifier): array
    {
        $encoded['categories'] = $encoded['categories'] ?? [];
        $encoded['categories'][$identifier] = $identifier;
        return $encoded;
    }

    private function addTag(array $encoded, string $identifier): array
    {
        $encoded['eventTags'] = $encoded['eventTags'] ?? [];
        $encoded['eventTags'][$identifier] = $identifier;
        return $encoded;
    }

    /**
     * @param string[] $types
     * @return string
     */
    private function typeRegex(array $types): string
    {
        $typeRegexPart = implode('|', $types);
        return '/(?<type>' . $typeRegexPart . '):(?<identifier>[a-zA-Z0-9_\-]*)(:(?<value>[a-zA-Z0-9]+))?/';
    }
}
