<?php declare(strict_types=1);

namespace Newland\Toubiz\Events\Neos\ViewHelpers\Link\FilteredLists;

use Neos\ContentRepository\Domain\Model\Node;
use Neos\FluidAdaptor\Core\ViewHelper\AbstractTagBasedViewHelper;
use Neos\Flow\Annotations as Flow;
use Neos\Neos\Service\LinkingService;
use Newland\NeosCommon\Service\NodeService;

class MoreViewHelper extends AbstractTagBasedViewHelper
{
    protected $tagName = 'a';

    /**
     * @var LinkingService
     * @Flow\Inject()
     */
    protected $linkingService;

    /**
     * @var NodeService
     * @Flow\Inject()
     */
    protected $nodeService;

    public function initializeArguments(): void
    {
        $this->registerArgument('node', Node::class, 'Node to use as a reference', true);
        $this->registerUniversalTagAttributes();
    }

    public function render(): string
    {
        $documentNode = $this->nodeService->getDocumentNode($this->arguments['node']);

        $href = $this->linkingService->createNodeUri(
            $this->controllerContext,
            $documentNode,
            $documentNode,
            'html',
            true,
            [ 'page' => 2 ]
        );

        $this->tag->setContent($this->renderChildren());
        $this->tag->addAttribute('href', $href);
        $this->tag->forceClosingTag(true);
        return $this->tag->render();
    }
}
