<?php
namespace Newland\Toubiz\Events\Neos\ViewHelpers\Link;

/*
 * This file is part of the "toubiz-events-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use DateTime;
use Neos\ContentRepository\Domain\Model\Node;
use Neos\ContentRepository\Domain\Model\NodeInterface;
use Neos\ContentRepository\TypeConverter\NodeConverter;
use Neos\Flow\Mvc\ActionRequest;
use Neos\FluidAdaptor\Core\ViewHelper\AbstractTagBasedViewHelper;
use Neos\Flow\Annotations as Flow;
use Neos\Neos\Domain\Service\ContentContext;
use Newland\Toubiz\Events\Neos\Service\EventUrlService;
use Newland\Toubiz\Sync\Neos\Domain\Model\EventDate;

class EventDateViewHelper extends AbstractLinkViewHelper
{
    public function initializeArguments()
    {
        parent::initializeArguments();
        $this->registerArgument('date', EventDate::class, 'The event date to link to.', false, null);
        $this->registerArgument('currentNode', Node::class, 'The current node (used as reference)', false, null);
    }

    public function render(): string
    {
        $date = $this->arguments['date'];
        $currentNode = $this->arguments['currentNode'];

        if (!$date) {
            return $this->isInBackend() ? 'Error: No date specified.' : '';
        }

        $this->tag->addAttribute('href', $this->generateUrl($date->getEvent(), $date, $currentNode));
        $this->tag->setContent($this->renderChildren());
        return $this->tag->render();
    }
}
