<?php

namespace Newland\Toubiz\Events\Neos\PageFrame;

use Neos\ContentRepository\Domain\Model\NodeInterface;
use Newland\PageFrameProvider\Definition\RoutingConfigurationHelper;
use Newland\PageFrameProvider\Routing\UriResolver;
use Neos\Flow\Annotations as Flow;
use Newland\PageFrameProvider\Service\PageFrameLinkingService;

/**
 * @Flow\Scope("singleton")
 */
class EventUriResolver implements UriResolver
{

    // Constants that identify the events plugin.
    const PACKAGE = 'newland.toubiz.events.neos';
    const CONTROLLER = 'events';
    const ACTION = 'show';

    // Plugin namespace as setup by the Fusion Object.
    const ARGUMENT_NAMESPACE = PageFrameLinkingService::DEFAULT_ARGUMENT_NAMESPACE;

    // The plugin argument that is used to determine the article type.
    const TYPE_ARGUMENT = '_type';

    // Configuration key to use if there is no detail URL for the specific article type.
    const TYPE_FALLBACK = '_fallback';

    // Url that is used if there is not even a `_fallback` configured (instead of simply failing altogether).
    const ULTIMATE_FALLBACK_URL = 'event/detail';

    /**
     * @var array
     * @Flow\InjectConfiguration(package="Newland.Toubiz.Events.Neos", path="detailPage")
     */
    protected $types;

    /**
     * @var PageFrameLinkingService
     * @Flow\Inject()
     */
    protected $pageFrameLinkingService;

    /**
     * @var RoutingConfigurationHelper
     * @Flow\Inject()
     */
    protected $configurationHelper;


    public function getMatchingDomainSpecificPath(string $requestPath): ?string
    {
        $this->configurationHelper->setTypeConfiguration($this->types);
        return $this->configurationHelper->getUriSegmentsFromRoutePath($requestPath);
    }

    public function resolveDomainSpecificPath(array &$routeValues, NodeInterface $node): ?string
    {
        $this->configurationHelper->setTypeConfiguration($this->types);
        if (!$this->isTryingToBuildEventUrl($routeValues)) {
            return null;
        }

        $type = $routeValues[static::ARGUMENT_NAMESPACE][static::TYPE_ARGUMENT] ?? static::TYPE_FALLBACK;
        unset($routeValues[static::ARGUMENT_NAMESPACE][static::TYPE_ARGUMENT]);
        return $this->configurationHelper->urlFragmentForType($type) ?? static::ULTIMATE_FALLBACK_URL;
    }

    private function isTryingToBuildEventUrl(array $routeValues): bool
    {
        $type = $routeValues[static::ARGUMENT_NAMESPACE][static::TYPE_ARGUMENT] ?? null;

        $isPageFrameActionLink = $this->pageFrameLinkingService->isPageFrameActionLink(
            $routeValues,
            static::PACKAGE,
            static::CONTROLLER,
            static::ACTION,
            static::ARGUMENT_NAMESPACE
        );

        return $isPageFrameActionLink && $type !== null;
    }
}
