<?php
namespace Newland\Toubiz\Events\Neos\ViewHelpers\Link;

/*
 * This file is part of the "toubiz-events-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use DateTime;
use Neos\ContentRepository\Domain\Model\Node;
use Neos\FluidAdaptor\Core\ViewHelper\AbstractTagBasedViewHelper;
use Neos\Flow\Annotations as Flow;
use Newland\Toubiz\Events\Neos\Service\EventUrlService;
use Newland\Toubiz\Sync\Neos\Domain\Model\Event;

class EventViewHelper extends AbstractTagBasedViewHelper
{
    /**
     * @var string
     */
    protected $tagName = 'a';

    /**
     * @var EventUrlService
     * @Flow\Inject
     */
    protected $eventUrlService;

    /**
     * @return void
     */
    public function initializeArguments()
    {
        $this->registerUniversalTagAttributes();
        $this->registerTagAttribute('target', 'string', 'Link target (e.g. _blank)');
    }

    /**
     * @param Event $event
     * @param Node $currentNode
     * @return string
     * @throws \Neos\Eel\Exception
     * @throws \Neos\Neos\Exception
     */
    public function render(Event $event = null, Node $currentNode = null): string
    {
        $today = new DateTime();

        if (!$event) {
            if ($this->isBackend()) {
                return 'Error: No event specified.';
            }
            return '';
        } elseif ($event !== null && $event->getEndsAt() <= $today) {
            if ($this->isBackend()) {
                return 'Error: The event as expired at ' . $event->getEndsAt()->format('Y-m-d');
            }
            return '';
        }

        if ($currentNode) {
            $url = $this->eventUrlService->generateUrlByCurrentNode($event, $currentNode);
        } else {
            $url = $this->eventUrlService->generateUrl($event, $this->controllerContext);
        }
        $this->tag->addAttribute('href', $url);
        $this->tag->setContent($this->renderChildren());
        return $this->tag->render();
    }

    private function isBackend(): bool
    {
        return $this->controllerContext->getRequest()
            ->getInternalArgument('__node')
            ->getContext()
            ->isInBackend();
    }
}
