<?php declare(strict_types=1);
namespace Newland\Toubiz\Events\Neos\Service;

use Neos\Flow\Annotations as Flow;
use Neos\Flow\Configuration\ConfigurationManager;
use Newland\NeosCommon\Domain\Model\Topic;
use Newland\NeosCommon\Service\AbstractRegionService;
use Newland\Toubiz\Events\Neos\Domain\Repository\TopicRepository;

class RegionService extends AbstractRegionService
{
    private $regions;

    protected function regionsAvailable(ConfigurationManager $configurationManager): array
    {
        return (array) $configurationManager->getConfiguration(
            ConfigurationManager::CONFIGURATION_TYPE_SETTINGS,
            'Newland.Toubiz.Events.Neos.regions.available'
        );
    }

    protected function regionsEnabled(ConfigurationManager $configurationManager): array
    {
        return (array) $configurationManager->getConfiguration(
            ConfigurationManager::CONFIGURATION_TYPE_SETTINGS,
            'Newland.Toubiz.Events.Neos.regions.enabled'
        );
    }

    /**
     * Returns all available regions which are also enabled.
     *
     * @return Topic[]|null
     */
    public function regionsAttainable(): ?array
    {
        if ($this->regions === null) {
            $regionsEnabled = $this->regionsEnabled;

            $attainable = array_filter(
                $this->regionsAvailable,
                function ($region) use ($regionsEnabled) {
                    return in_array($region, $regionsEnabled);
                },
                ARRAY_FILTER_USE_KEY
            );

            foreach ($attainable as $region => $config) {
                $this->regions[] = new Topic(
                    TopicRepository::TYPE_REGION,
                    $region,
                    $config['name']
                );
            }
        }

        return $this->regions;
    }

    /**
     * @param string $identifier
     * @return Topic|null
     */
    public function findByIdentifier(string $identifier)
    {
        foreach ($this->regionsAttainable() as $region) {
            if ($region->getIdentifier() === $identifier) {
                return $region;
            }
        }
        return null;
    }
}
