<?php
namespace Newland\Toubiz\Events\Neos\ViewHelpers\Link;

/*
 * This file is part of the "toubiz-events-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\ContentRepository\Domain\Model\Node;
use Neos\FluidAdaptor\Core\ViewHelper\AbstractTagBasedViewHelper;
use Neos\Flow\Annotations as Flow;
use Newland\Toubiz\Events\Neos\Service\EventUrlService;
use Newland\Toubiz\Sync\Neos\Domain\Model\Event;

class EventViewHelper extends AbstractTagBasedViewHelper
{
    /**
     * @var string
     */
    protected $tagName = 'a';

    /**
     * @var EventUrlService
     * @Flow\Inject
     */
    protected $eventUrlService;

    /**
     * @return void
     */
    public function initializeArguments()
    {
        $this->registerUniversalTagAttributes();
        $this->registerTagAttribute('target', 'string', 'Link target (e.g. _blank)');
    }

    public function render(Event $event = null, Node $currentNode = null): string
    {
        if (!$event) {
            $isInBackend = $this->controllerContext->getRequest()
                ->getInternalArgument('__node')
                ->getContext()
                ->isInBackend();

            if ($isInBackend) {
                return 'Error: No event specified.';
            }
            return '';
        }

        if ($currentNode) {
            $url = $this->eventUrlService->generateUrlByCurrentNode($event, $currentNode);
        } else {
            $url = $this->eventUrlService->generateUrl($event, $this->controllerContext);
        }
        $this->tag->addAttribute('href', $url);
        $this->tag->setContent($this->renderChildren());
        return $this->tag->render();
    }
}
