<?php declare(strict_types=1);
namespace Newland\Toubiz\Events\Neos\ViewHelpers\Teaser;

/*
 * This file is part of the "toubiz-events-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Newland\Toubiz\Sync\Neos\Domain\Model\Event;
use Neos\FluidAdaptor\Core\ViewHelper\AbstractViewHelper;

/**
 * Simple ViewHelper that checks whether an event is expired.
 *
 * @example
 * The following example will only render content, if the current event exists and is not expired:
 * <f:if condition="{events:teaser.isExpired(event: event)} == false">
 * </f:if>
 */
class IsExpiredViewHelper extends AbstractViewHelper
{
    public function render(Event $event = null): bool
    {
        if ($event) {
            return $event->isExpired();
        }

        return true;
    }
}
