<?php declare(strict_types=1);

namespace Newland\Toubiz\Events\Neos\Tests\Unit\Sitemap;

use Neos\Flow\Tests\FunctionalTestCase;
use Newland\NeosTestingHelpers\InteractsWithNodes;
use Newland\Toubiz\Events\Neos\Sitemap\EventDetailSitemapProvider;
use Newland\Toubiz\Sync\Neos\Tests\Factory\EventFactory;

class EventDetailSitemapProviderTest extends FunctionalTestCase
{
    use InteractsWithNodes;

    protected static $testablePersistenceEnabled = true;

    /** @var EventDetailSitemapProvider */
    protected $subject;

    public function setUp(): void
    {
        parent::setUp();
        $this->subject = $this->objectManager->get(EventDetailSitemapProvider::class);
    }

    public function testProvidesLinksForEvents(): void
    {
        $site = $this->initializeSite('foo');
        $node = $this->initializeNode('/sites/foo', null, $site);

        (new EventFactory($this->objectManager))->createMultiple(3);
        self::assertCount(3, $this->subject->getPages($node));
    }
}
