<?php declare(strict_types=1);
namespace Newland\Toubiz\Events\Neos\ViewHelpers\Link;

/*
 * This file is part of the "toubiz-events-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\ContentRepository\Domain\Model\Node;
use Newland\Toubiz\Sync\Neos\Domain\Model\Event;

class EventViewHelper extends AbstractLinkViewHelper
{
    public function render(Event $event = null, Node $currentNode = null): string
    {
        if (!$event) {
            return $this->isInBackend() ? 'Error: No event specified.' : '';
        }

        if ($event->isExpired() && $event->getEndsAt() !== null) {
            return $this->isInBackend() ?
                'Error: The event has expired at ' . $event->getEndsAt()->format('Y-m-d H:i:s') :
                '';
        }

        $this->tag->addAttribute('href', $this->generateUrl($event, null, $currentNode));
        $this->tag->setContent($this->renderChildren());
        return $this->tag->render();
    }
}
