<?php declare(strict_types=1);
namespace Newland\Toubiz\Events\Neos\Service;

use Neos\ContentRepository\Domain\Model\NodeInterface;
use Neos\Flow\Annotations as Flow;
use Neos\Flow\Configuration\ConfigurationManager;
use Newland\NeosCommon\Service\AbstractRegionService;
use Newland\NeosCommon\Service\ConfigurationService;

class RegionService extends AbstractRegionService
{
    /**
     * @var ConfigurationService
     * @Flow\Inject()
     */
    protected $configurationService;

    protected function getRegionsAvailable(): array
    {
        return (array) $this->configurationManager->getConfiguration(
            ConfigurationManager::CONFIGURATION_TYPE_SETTINGS,
            'Newland.Toubiz.Events.Neos.regions.available'
        );
    }

    protected function getRegionsEnabled(NodeInterface $node): array
    {
        $configuration = (array) $this->configurationManager->getConfiguration(
            ConfigurationManager::CONFIGURATION_TYPE_SETTINGS,
            'Newland.Toubiz.Events.Neos.regions.enabled'
        );

        if ($configuration['default'] ?? null) {
            $configuration = $this->configurationService->getCurrentSiteConfiguration(
                $node,
                'Newland.Toubiz.Events.Neos.regions.available'
            );
        }

        return $configuration;
    }
}
