<?php declare(strict_types=1);

namespace Newland\Toubiz\Events\Neos\PublicViewHelpers\Widget;

use Neos\ContentRepository\Domain\Model\NodeInterface;
use Neos\FluidAdaptor\Core\Widget\AbstractWidgetViewHelper;
use Neos\Flow\Annotations as Flow;
use Newland\Toubiz\Events\Neos\PublicViewHelpers\Widget\Controller\SimplisticTeaserListController;

class SimplisticTeaserListViewHelper extends AbstractWidgetViewHelper
{

    /**
     * @var SimplisticTeaserListController
     * @Flow\Inject()
     */
    protected $controller;

    public function initializeArguments()
    {
        parent::initializeArguments();
        $this->registerArgument(
            'node',
            NodeInterface::class,
            'Node used as a reference',
            true
        );
        $this->registerArgument(
            'limit',
            'int',
            'Number of items to return',
            false,
            3
        );
        $this->registerArgument(
            'overrides',
            'array',
            'Filter overrides',
            false,
            []
        );
    }

    public function render(): string
    {
        return $this->initiateSubRequest()->getContent();
    }
}
