<?php declare(strict_types=1);

namespace Newland\Toubiz\Events\Neos\PublicViewHelpers\Widget\Controller;

use Neos\FluidAdaptor\Core\Widget\AbstractWidgetController;
use Newland\Toubiz\Events\Neos\Filter\EventDateFilterFactory;
use Neos\Flow\Annotations as Flow;

class SimplisticTeaserListController extends AbstractWidgetController
{

    /**
     * @var array
     * @Flow\InjectConfiguration(path="filter")
     */
    protected $filterSettings;

    public function indexAction(): void
    {
        $filter = (new EventDateFilterFactory($this->widgetConfiguration['node']))
            ->createEventFilter([], $this->widgetConfiguration['overrides'])
            ->setPageSize($this->widgetConfiguration['limit']);

        $this->view->assignMultiple(
            [
                'eventDates' => $filter->getEventQuery()->getQuery()->execute()
            ]
        );
    }
}
