<?php
namespace Newland\Toubiz\Events\Neos\PageFrame;

use Neos\ContentRepository\Domain\Model\NodeInterface;
use Neos\Eel\FlowQuery\FlowQuery;
use Newland\PageFrameProvider\Definition\RoutingConfigurationHelper;
use Neos\Flow\Annotations as Flow;
use Newland\PageFrameProvider\Breadcrumb\BreadcrumbProvider;

class EventBreadcrumbProvider implements BreadcrumbProvider
{

    /**
     * @var array
     * @Flow\InjectConfiguration(package="Newland.Toubiz.Events.Neos", path="detailPage")
     */
    protected $types;

    /**
     * @var RoutingConfigurationHelper
     * @Flow\Inject()
     */
    protected $configurationHelper;

    /**
     * Must return an array of nodes that should be in the breadcrumb before
     * the current page. The first node in the array corresponds to the first
     * array in the breadcrumb (closest to the siteNode).
     *
     * @param NodeInterface $siteNode
     * @param array $configuration
     * @return NodeInterface[]
     */
    public function selectBreadCrumbs(NodeInterface $siteNode, array $configuration): array
    {
        $this->configurationHelper->setTypeConfiguration($this->types);
        $definition = $this->configurationHelper->getDefinition('default')
            ?? $this->configurationHelper->getDefinition('_fallback');
        if (!$definition) {
            return [];
        }

        $breadcrumb = $definition->getBreadcrumb($siteNode->getName());
        $selector = $siteNode->getPath() . ', ' . implode(', ', $breadcrumb);
        return (new FlowQuery([ $siteNode ]))->find($selector)->get();
    }
}
